<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>
<main>
    <div class="container">
        <div class="row z-depth-1-half
 " >
            <form action="<?php echo base_url() ?>competitor/search" method="get">


                <div class="col s12 xl2 input-field">
                    <span style="font-weight: bold"><?php echo $text_competitors['competitor_sort_text']?></span>
                </div>
                <div class="col xl2 s6 input-field">
                    <i class="material-icons prefix">date_range</i>
                    <input type="date" name="fecha_inicio" id="fecha_inicio"
                           value="<?php echo $this->input->get('fecha_inicio') ?>" required/>
                    <label for="fecha_inicio"><?php echo $text_competitors['competitor_date_since']?></label>
                </div>
                <div class="col xl2 s6 input-field">
                    <i class="material-icons prefix">date_range</i>
                    <input type="date" name="fecha_fin" id="fecha_fin" value="<?php echo $this->input->get('fecha_fin') ?>" required "/>

                    <label for="fecha_fin"><?php echo $text_competitors['competitor_date_until']?></label>
                </div>
                <div class="col xl2 s6 input-field">
                    <i class="material-icons prefix">list</i>

                    <select name="agegroup" id="agegroup" onchange="changeWeights(this.value)">
                        <!--                    <option value="" disabled-->
                        <!--                            selected> Age group-->
                        <!--                    </option>-->
                        <?php foreach ($agegroup as $group) { ?>
                            <option value="<?php echo $group->idGrupoEdad; ?>"
                                <?php if (isset($_GET['agegroup'])) {
                                    echo $group->idGrupoEdad == $this->input->get('agegroup') ? 'selected' : null;
                                } else if ($group->idGrupoEdad == 6) echo "selected"; ?>><?php echo $group->descripcion; ?>
                            </option>
                        <?php } ?>

                    </select>

                </div>
                <div class="col xl2 s6 input-field">
                    <i class="material-icons prefix">list</i>

                    <select name="weight" id="weightSelect">
                        <option value="0" selected>  <?php echo $text_competitors['competitor_weight']?></option>
                        <?php $idWeightGET = isset($_GET['agegroup']) ? $_GET['agegroup'] : 6; ?>
                        <optgroup label="M">
                            <?php foreach ($weights as $weight) { ?>

                                <?php if ($weight->idGrupoEdad == $idWeightGET && $weight->sexo == 'M') { ?>
                                    <option value="<?php echo $weight->idPeso ?>"<?php echo $weight->idPeso == $this->input->get('weight') ? 'selected' : null; ?>><?php echo $weight->descripcion ?> Kg
                                    </option>
                                <?php } ?>

                            <?php } ?>

                        </optgroup>
                        <optgroup label="F">
                            <?php foreach ($weights as $weight) { ?>

                                <?php if ($weight->idGrupoEdad == $idWeightGET && $weight->sexo == 'F') { ?>
                                    <option value="<?php echo $weight->idPeso ?>"<?php echo $weight->idPeso == $this->input->get('weight') ? 'selected' : null; ?>><?php echo $weight->descripcion ?>
                                        Kg
                                    </option>
                                <?php } ?>

                            <?php } ?>

                        </optgroup>
                    </select>

                </div>
                <div class="col xl2 s2 offset-s5 input-field">

                    <button class="btn btn-floating large waves-effect indigo lighten-2" onclick="return compareDates()">
                        <i class="material-icons center">search</i>
                    </button>
                </div>
            </form>

        </div>
    </div>
    <div class="container ">

        <div class="row z-depth-3">
            <!--    --><?php //echo $this -> table -> generate($competitors)?>
            <?php $count = 0; ?>
            <ul class="collapsible popout " data-collapsible="expandable">

                <?php foreach ($competitors as $competitor) { ?>

                    <li>
                        <div class="collapsible-header <?php echo $count % 2 == 0 ? 'grey lighten-2' : null; ?>  ">
                            <i class="material-icons">expand_more</i></i>
                            <table class="responsive-table">
                                <thead>
                                <tr>
                                    <th> <?php echo $text_competitors['competitor_name']?></th>
                                    <th> <?php echo $text_competitors['competitor_surname']?></th>
                                    <th> <?php echo $text_competitors['competitor_surname2']?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td> <?php echo $competitor -> getNombre() == null ? '-' : $competitor -> getNombre();?></td>
                                    <td> <?php echo $competitor -> getApellido1() == null ? '-' : $competitor -> getApellido1();?></td>
                                    <td> <?php echo $competitor -> getApellido2() == null ? '-' : $competitor -> getApellido2();?></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="collapsible-body row">
                            <div class="col s12">
                                <?php echo $competitor->getProvincia(); ?>,
                                <?php echo $competitor->getAutonomia(); ?>
                            </div>
                            <div class="col s12">
                                <span style="font-weight: bold"> <?php echo $text_competitors['competitor_medal_table']?> ( <?php echo isset($_GET['fecha_inicio']) ?$_GET['fecha_inicio'] : '- infinito' ?> ,<?php echo isset($_GET['fecha_fin']) ?$_GET['fecha_fin'] : '+ infinito' ?>)</span>
                            </div>
                            <div class="col s12">
                                <table class="bordered centered responsive-table">
                                    <thead>
                                    <tr>
                                        <th> <?php echo $text_competitors['competitor_medal_gold']?></th>
                                        <th> <?php echo $text_competitors['competitor_medal_silver']?></th>
                                        <th> <?php echo $text_competitors['competitor_medal_bronze']?></th>
                                        <th> 5</th>
                                        <th> 7</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    <tr>
                                        <th class="amber lighten-3 center"><?php echo $competitor->getPuntuacion()['oro'] ?></th>
                                        <th class="grey lighten-3 center"><?php echo $competitor->getPuntuacion()['plata'] ?></th>
                                        <th class="brown lighten-3 center"><?php echo $competitor->getPuntuacion()['bronce'] ?></th>
                                        <th class="center"><?php echo $competitor->getPuntuacion()['quinto'] ?></th>
                                        <th class="center"><?php echo $competitor->getPuntuacion()['septimo'] ?></th>
                                    </tr>
                                    </tbody>

                                </table>
                            </div>

                        </div>
                    </li>
                    <?php $count++;
                } ?>
            </ul>
            <?php echo $this->pagination->create_links(); ?>
            <?php if (!$competitors) { ?>
                <span style="font-weight: bold"> No hay competidores con esas caracteristicas</span>
            <?php } ?>
        </div>
    </div>

</main>
<body>




</body>


<script>
    /**
     * En la busqueda de competidores la fehca de inicio debe ser menor a la fecha fin de temporada
     * si no provocaria fallo en la base de datos
     * @returns {boolean}
     */
    function compareDates() {
        var date1 = $('#fecha_inicio').val();
        var date2 = $('#fecha_fin').val();
        var agegroup = $('#agegroup').val();
        var weight = $('#weight').val();

        if (date1 == '') {
            Materialize.toast('<?php echo $text_competitors['competitor_toast_date']?>',2000);
            return false;
        }
        if (date2 == '') {
            Materialize.toast('<?php echo $text_competitors['competitor_toast_date']?>',2000);
            return false;
        }


        if (date1 > date2) {
            Materialize.toast(' <?php echo $text_competitors['competitor_toast_date_interval']?>',2000);
            return false;
        }

    }
    function changeWeights(value) {
        const FEMALE = "F";
        const MALE = "M";
        $('#weightSelect').find('option').remove(); // Eliminamos lo que habia antes en el dropdown select
        $("#weightSelect").append('<option value="0">Peso</option>'); // Añadimos las opciones correspondientes

        $("#weightSelect").append('<optgroup label = "M"'); // Añadimos las opciones correspondientes
        <?php

        foreach ($weights as $weight) {?>
        if(value == <?php echo $weight -> idGrupoEdad?> && MALE == "<?php echo $weight -> sexo?>")
        $("#weightSelect").append('<option value="<?php echo $weight->idPeso?>">'  +'<?php echo $weight->descripcion?> Kg</option>'); // Añadimos las opciones correspondientes

        <?php }?>
        $("#weightSelect").append('</optgroup>'); // Añadimos las opciones correspondientes
        $("#weightSelect").append('<optgroup label = "F"'); // Añadimos las opciones correspondientes
        <?php

        foreach ($weights as $weight) {?>
        if(value == <?php echo $weight -> idGrupoEdad?> && FEMALE == "<?php echo $weight -> sexo?>")
            $("#weightSelect").append('<option value="<?php echo $weight->idPeso?>">'  +'<?php echo $weight->descripcion?> Kg</option>'); // Añadimos las opciones correspondientes

        <?php }?>
        $("#weightSelect").append('</optgroup>'); // Añadimos las opciones correspondientes
        $('#weightSelect').material_select('update'); // Obligatorio con materialize, update despues de añadir, eliminar algun option del  dropdown


    }


</script>